package test

import (
	"os"
	"testing"
)

// Aby uniknąć marnowania czasu na nieustanne tworzenie i usuwanie kubełków S3 dla testów wymagających przechowywania danych stanu
// w S3, niektóre testy wymagają wcześniejszego utworzenia kubełka S3 oraz zdefiniowania jego nazwy
// i regionu w zmiennych środowiskowych.
const TerraformStateBucketForTestEnvVarName = "TEST_STATE_S3_BUCKET"
const TerraformStateRegionForTestEnvVarName = "TEST_STATE_REGION"

// Pobranie wartości zmiennej środowiskowej o podanej nazwie. Jeżeli nie została zdefiniowana,
// wówczas test powinien zakończyć się niepowodzeniem.
func GetRequiredEnvVar(t *testing.T, envVarName string) string {
	envVarValue := os.Getenv(envVarName)
	if envVarValue == "" {
		t.Fatalf("Wymagana zmienna środowiskowa '%s' nie została zdefiniowana", envVarName)
	}
	return envVarValue
}
